/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Collection;
import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.ForageCost;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class OsteomancerAdeptEffect
extends AsThoughEffectImpl {
    OsteomancerAdeptEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.AIDontUseIt);
        this.staticText = "until end of turn, you may cast creature spells from your graveyard by foraging in addition to paying their other costs. If you cast a spell this way, that creature enters with a finality counter on it.";
    }

    private OsteomancerAdeptEffect(OsteomancerAdeptEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public OsteomancerAdeptEffect copy() {
        return new OsteomancerAdeptEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId)) {
            return false;
        }
        Card card = game.getCard(objectId);
        Player player = game.getPlayer(affectedControllerId);
        if (!(card != null && player != null && card.isOwnedBy(affectedControllerId) && card.isCreature(game) && game.getState().getZone(objectId).match(Zone.GRAVEYARD))) {
            return false;
        }
        CostsImpl newCosts = new CostsImpl();
        newCosts.addAll((Collection)card.getSpellAbility().getCosts());
        newCosts.add((Object)new ForageCost());
        player.setCastSourceIdWithAlternateMana(card.getId(), card.getManaCost(), (Costs)newCosts, MageIdentifier.OsteomancerAdeptAlternateCast);
        return true;
    }
}

