/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class OswaldFiddlebenderEffect
extends OneShotEffect {
    OswaldFiddlebenderEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for an artifact card with mana value equal to 1 plus the sacrificed artifact's mana value, put it onto the battlefield, then shuffle";
    }

    private OswaldFiddlebenderEffect(OswaldFiddlebenderEffect effect) {
        super((OneShotEffect)effect);
    }

    public OswaldFiddlebenderEffect copy() {
        return new OswaldFiddlebenderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sacrificed = source.getCosts().stream().filter(SacrificeTargetCost.class::isInstance).map(SacrificeTargetCost.class::cast).map(SacrificeTargetCost::getPermanents).flatMap(Collection::stream).findFirst().orElse(null);
        if (player == null || sacrificed == null) {
            return false;
        }
        FilterArtifactCard filterCard = new FilterArtifactCard("artifact card with mana value " + (sacrificed.getManaValue() + 1));
        filterCard.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, sacrificed.getManaValue() + 1));
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)filterCard);
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

