/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.OtterProwessToken;
import mage.game.stack.Spell;

class OtterballAnticsEffect
extends OneShotEffect {
    OtterballAnticsEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 blue and red Otter creature token with prowess. If this spell was cast from anywhere other than your hand, put a +1/+1 counter on that creature";
    }

    private OtterballAnticsEffect(OtterballAnticsEffect effect) {
        super((OneShotEffect)effect);
    }

    public OtterballAnticsEffect copy() {
        return new OtterballAnticsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        OtterProwessToken token = new OtterProwessToken();
        token.putOntoBattlefield(1, game, source);
        Spell spell = Optional.ofNullable(source.getSourceObjectIfItStillExists(game)).filter(Spell.class::isInstance).map(Spell.class::cast).orElse(null);
        if (spell == null || Zone.HAND.match(spell.getFromZone())) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        }
        return true;
    }
}

