/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.o.OutlawStitcherDynamicValue;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieRogueToken;

class OutlawStitcherEffect
extends OneShotEffect {
    OutlawStitcherEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a 2/2 blue and black Zombie Rogue creature token, then put two +1/+1 counters on that token for each spell you've cast this turn other than the first";
    }

    private OutlawStitcherEffect(OutlawStitcherEffect effect) {
        super((OneShotEffect)effect);
    }

    public OutlawStitcherEffect copy() {
        return new OutlawStitcherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenEffect effect = new CreateTokenEffect((Token)new ZombieRogueToken());
        boolean result = effect.apply(game, source);
        int xvalue = OutlawStitcherDynamicValue.instance.calculate(game, source, (Effect)this);
        if (xvalue <= 0 || !result) {
            return result;
        }
        for (UUID id : effect.getLastAddedTokenIds()) {
            Permanent token = game.getPermanent(id);
            if (token == null) continue;
            token.addCounters(CounterType.P1P1.createInstance(2 * xvalue), source.getControllerId(), source, game);
        }
        return true;
    }
}

