/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;

class OverTheTopEffect
extends OneShotEffect {
    OverTheTopEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player reveals a number of cards from the top of their library equal to the number of nonland permanents they control, puts all permanent cards they revealed this way onto the battlefield, and puts the rest into their graveyard";
    }

    private OverTheTopEffect(OverTheTopEffect effect) {
        super((OneShotEffect)effect);
    }

    public OverTheTopEffect copy() {
        return new OverTheTopEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Map<UUID, Integer> map = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, source.getControllerId(), source, game).stream().collect(Collectors.toMap(Controllable::getControllerId, x -> 1, Integer::sum));
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            int nonlands = map.getOrDefault(playerId, 0);
            if (player == null || nonlands < 1) continue;
            CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, nonlands));
            player.revealCards(source, (Cards)cards, game);
            Cards toGrave = cards.copy();
            cards.removeIf(uuid -> !game.getCard(uuid).isPermanent(game));
            player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
            toGrave.retainZone(Zone.LIBRARY, game);
            player.moveCards(toGrave, Zone.GRAVEYARD, source, game);
        }
        return true;
    }
}

