/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.condition.common.KickedCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OverloadEffect
extends OneShotEffect {
    OverloadEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target artifact if its mana value is 2 or less. If this spell was kicked, destroy that artifact if its mana value is 5 or less instead.";
    }

    private OverloadEffect(OverloadEffect effect) {
        super((OneShotEffect)effect);
    }

    public OverloadEffect copy() {
        return new OverloadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int cmc;
            Permanent targetArtifact = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetArtifact != null && ((cmc = targetArtifact.getManaValue()) <= 2 || KickedCondition.ONCE.apply(game, source) && cmc <= 5)) {
                targetArtifact.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

