/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class OverwhelmingSplendorCantActivateEffect
extends ContinuousRuleModifyingEffectImpl {
    OverwhelmingSplendorCantActivateEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Enchanted player can't activate abilities that aren't mana abilities or loyalty abilities";
    }

    private OverwhelmingSplendorCantActivateEffect(OverwhelmingSplendorCantActivateEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public OverwhelmingSplendorCantActivateEffect copy() {
        return new OverwhelmingSplendorCantActivateEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't activate abilities that aren't mana abilities or loyalty abilities (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (enchantment == null || !event.getPlayerId().equals(enchantment.getAttachedTo())) {
            return false;
        }
        Optional ability = game.getAbility(event.getTargetId(), event.getSourceId());
        return ability.isPresent() && !((Ability)ability.get()).isManaActivatedAbility() && !(ability.get() instanceof LoyaltyAbility);
    }
}

