/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.target.Target;
import mage.target.TargetPermanent;

class AugustaDeanOfOrderEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    public AugustaDeanOfOrderEffect() {
        super(Outcome.Benefit);
        this.staticText = "tap any number of creatures you control";
    }

    private AugustaDeanOfOrderEffect(AugustaDeanOfOrderEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)filter, true);
        Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.chooseTarget(Outcome.Benefit, (Target)target, source, game));
        for (UUID targetId : target.getTargets()) {
            Optional.ofNullable(targetId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> permanent.tap(source, game));
        }
        return true;
    }

    public AugustaDeanOfOrderEffect copy() {
        return new AugustaDeanOfOrderEffect(this);
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

