/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PacksDisdainEffect
extends OneShotEffect {
    PacksDisdainEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Choose a creature type. Target creature gets -1/-1 until end of turn for each permanent of the chosen type you control";
    }

    private PacksDisdainEffect(PacksDisdainEffect effect) {
        super((OneShotEffect)effect);
    }

    public PacksDisdainEffect copy() {
        return new PacksDisdainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
        if (player != null && player.choose(Outcome.UnboostCreature, (Choice)typeChoice, game)) {
            FilterControlledPermanent filter = new FilterControlledPermanent(SubType.byDescription((String)typeChoice.getChoiceKey()));
            PermanentsOnBattlefieldCount negativePermanentsCount = new PermanentsOnBattlefieldCount((FilterPermanent)filter, Integer.valueOf(-1));
            BoostTargetEffect effect = new BoostTargetEffect((DynamicValue)negativePermanentsCount, (DynamicValue)negativePermanentsCount, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

