/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.players.PlayerList;

class PainsRewardEffect
extends OneShotEffect {
    PainsRewardEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Each player may bid life. You start the bidding with a bid of any number. In turn order, each player may top the high bid. The bidding ends if the high bid stands. The high bidder loses life equal to the high bid and draws four cards";
    }

    private PainsRewardEffect(PainsRewardEffect effect) {
        super((OneShotEffect)effect);
    }

    public PainsRewardEffect copy() {
        return new PainsRewardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            PlayerList playerList = game.getPlayerList().copy();
            playerList.setCurrent((Object)controller.getId());
            Player winner = game.getPlayer(controller.getId());
            int highBid = this.chooseLifeAmountToBid(controller, -1, source, game);
            game.informPlayers(winner.getLogName() + " has bet " + highBid + " lifes");
            Player currentPlayer = playerList.getNextInRange(controller, game);
            while (currentPlayer != null && !Objects.equals(currentPlayer, winner)) {
                int newBid;
                Outcome aiOutcome;
                String text = winner.getLogName() + " has bet " + highBid + " life" + (highBid > 1 ? "s" : "") + ". Top the bid?";
                int safeLifeToLost = Math.min(6, currentPlayer.getLife() / 2);
                Outcome outcome = aiOutcome = highBid + 1 <= safeLifeToLost ? Outcome.Benefit : Outcome.Detriment;
                if (currentPlayer.chooseUse(aiOutcome, text, source, game) && (newBid = this.chooseLifeAmountToBid(currentPlayer, highBid, source, game)) > highBid) {
                    highBid = newBid;
                    winner = currentPlayer;
                    game.informPlayers(currentPlayer.getLogName() + " bet " + newBid + " life" + (newBid > 1 ? "s" : ""));
                }
                currentPlayer = playerList.getNextInRange(controller, game);
            }
            game.informPlayers(winner.getLogName() + " won the auction with a bid of " + highBid + " life" + (highBid > 1 ? "s" : ""));
            winner.loseLife(highBid, game, source, false);
            winner.drawCards(4, source, game);
            return true;
        }
        return false;
    }

    private int chooseLifeAmountToBid(Player player, int currentBig, Ability source, Game game) {
        int newBid = player.isComputer() ? currentBig + 1 : player.getAmount(currentBig + 1, Integer.MAX_VALUE, "Choose amount of life to bid", source, game);
        return newBid;
    }
}

