/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.p.PakoArcaneRetrieverWatcher;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PakoArcaneRetrieverEffect
extends OneShotEffect {
    PakoArcaneRetrieverEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of each player's library and put a fetch counter on each of them. Put a +1/+1 counter on {this} for each noncreature card exiled this way.";
    }

    private PakoArcaneRetrieverEffect(PakoArcaneRetrieverEffect effect) {
        super((OneShotEffect)effect);
    }

    public PakoArcaneRetrieverEffect copy() {
        return new PakoArcaneRetrieverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        PakoArcaneRetrieverWatcher watcher = (PakoArcaneRetrieverWatcher)game.getState().getWatcher(PakoArcaneRetrieverWatcher.class);
        if (controller == null || watcher == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getState().getPlayersInRange(controller.getId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getLibrary).map(library -> library.getFromTop(game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.removeIf(cardId -> game.getState().getZone(cardId) != Zone.EXILED);
        int counters = cards.count(StaticFilters.FILTER_CARD_NON_CREATURE, game);
        if (cards.isEmpty()) {
            return true;
        }
        cards.getCards(game).stream().filter(card -> card.addCounters(CounterType.FETCH.createInstance(), source.getControllerId(), source, game)).filter(card -> !card.isCreature(game)).forEach(card -> watcher.addCard(controller.getId(), (Card)card, game));
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null || counters == 0) {
            return true;
        }
        return permanent.addCounters(CounterType.P1P1.createInstance(counters), source.getControllerId(), source, game);
    }
}

