/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.p.ProtectionChosenColorTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PaleWayfarerEffect
extends OneShotEffect {
    PaleWayfarerEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Target creature gains protection from the color of its controller's choice until end of turn";
    }

    private PaleWayfarerEffect(PaleWayfarerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ChoiceColor colorChoice;
        Player player;
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null && (player = game.getPlayer(targetCreature.getControllerId())) != null && player.choose(Outcome.Neutral, (Choice)(colorChoice = new ChoiceColor()), game)) {
            game.informPlayers(targetCreature.getName() + ": " + player.getLogName() + " has chosen " + colorChoice.getChoice());
            game.getState().setValue(targetCreature.getId() + "_color", (Object)colorChoice.getColor());
            ObjectColor protectColor = (ObjectColor)game.getState().getValue(targetCreature.getId() + "_color");
            if (protectColor != null) {
                ProtectionChosenColorTargetEffect effect = new ProtectionChosenColorTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(targetCreature, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }

    public PaleWayfarerEffect copy() {
        return new PaleWayfarerEffect(this);
    }
}

