/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PandemoniumEffect
extends OneShotEffect {
    PandemoniumEffect() {
        super(Outcome.Benefit);
        this.staticText = "that creature's controller may have it deal damage equal to its power to any target of their choice";
    }

    private PandemoniumEffect(PandemoniumEffect effect) {
        super((OneShotEffect)effect);
    }

    public PandemoniumEffect copy() {
        return new PandemoniumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enteringCreature;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (enteringCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source)) != null) {
            Permanent targetPermanent = game.getPermanent(source.getTargets().getFirstTarget());
            if (targetPermanent != null) {
                targetPermanent.damage(enteringCreature.getPower().getValue(), enteringCreature.getId(), source, game, false, true);
            } else {
                Player targetPlayer = game.getPlayer(source.getTargets().getFirstTarget());
                if (targetPlayer != null) {
                    targetPlayer.damage(enteringCreature.getPower().getValue(), enteringCreature.getId(), source, game);
                }
            }
            return true;
        }
        return false;
    }
}

