/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.DiscoverEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PantlazaSunFavoredEffect
extends OneShotEffect {
    PantlazaSunFavoredEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "discover X, where X is that creature's toughness";
    }

    private PantlazaSunFavoredEffect(PantlazaSunFavoredEffect effect) {
        super((OneShotEffect)effect);
    }

    public PantlazaSunFavoredEffect copy() {
        return new PantlazaSunFavoredEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (player == null || permanent == null) {
            return false;
        }
        DiscoverEffect.doDiscover((Player)player, (int)Math.max(0, permanent.getToughness().getValue()), (Game)game, (Ability)source);
        return true;
    }
}

