/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CanBeSacrificedPredicate;
import mage.filter.predicate.permanent.GreatestPowerControlledPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.watchers.common.PlayerLostLifeWatcher;

class PapalymoTotolymoEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("a creature you control with the greatest power");

    PapalymoTotolymoEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent who lost life this turn sacrifices a creature with the greatest power among creatures they control";
    }

    private PapalymoTotolymoEffect(PapalymoTotolymoEffect effect) {
        super((OneShotEffect)effect);
    }

    public PapalymoTotolymoEffect copy() {
        return new PapalymoTotolymoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> permanents = new ArrayList<Permanent>();
        PlayerLostLifeWatcher watcher = (PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class);
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent;
            if (watcher.getLifeLost(opponentId) < 1 || (opponent = game.getPlayer(opponentId)) == null || !game.getBattlefield().contains(filter, opponentId, source, game, 1)) continue;
            TargetPermanent target = new TargetPermanent(filter);
            target.withNotTarget(true);
            target.withChooseHint("to sacrifice");
            opponent.choose(this.outcome, (Target)target, source, game);
            permanents.add(game.getPermanent(target.getFirstTarget()));
        }
        permanents.removeIf(Objects::isNull);
        for (Permanent permanent : permanents) {
            permanent.sacrifice(source, game);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)GreatestPowerControlledPredicate.instance);
        filter.add((Predicate)CanBeSacrificedPredicate.instance);
    }
}

