/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.filter.FilterSpell;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class ParadisePlumeSpellCastTriggeredAbility
extends TriggeredAbilityImpl {
    public ParadisePlumeSpellCastTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainLifeEffect(1), true);
        this.setTriggerPhrase("Whenever a player casts a spell of the chosen color, ");
    }

    private ParadisePlumeSpellCastTriggeredAbility(ParadisePlumeSpellCastTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ObjectColor color = (ObjectColor)game.getState().getValue(this.getSourceId() + "_color");
        if (color != null) {
            FilterSpell filter = new FilterSpell();
            filter.add((Predicate)new ColorPredicate(color));
            Spell spell = game.getStack().getSpell(event.getTargetId());
            return spell != null && filter.match((StackObject)spell, this.getControllerId(), (Ability)this, game);
        }
        return false;
    }

    public ParadisePlumeSpellCastTriggeredAbility copy() {
        return new ParadisePlumeSpellCastTriggeredAbility(this);
    }
}

