/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.game.Game;

class ParadoxicalOutcomeNumber
implements DynamicValue {
    private int zoneChangeCounter = 0;
    private final boolean previousZone;

    public ParadoxicalOutcomeNumber(boolean previousZone) {
        this.previousZone = previousZone;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Card card;
        if (this.zoneChangeCounter == 0 && (card = game.getCard(sourceAbility.getSourceId())) != null) {
            this.zoneChangeCounter = card.getZoneChangeCounter(game);
            if (this.previousZone) {
                --this.zoneChangeCounter;
            }
        }
        int number = 0;
        Integer sweepNumber = (Integer)game.getState().getValue("ParadoxicalOutcomeEffect" + sourceAbility.getSourceId() + this.zoneChangeCounter);
        if (sweepNumber != null) {
            number = sweepNumber;
        }
        return number;
    }

    public ParadoxicalOutcomeNumber copy() {
        return new ParadoxicalOutcomeNumber(this.previousZone);
    }

    public String toString() {
        return "X";
    }

    public String getMessage() {
        return "the number of permanents returned this way";
    }
}

