/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class ParagonOfTheAmesha
extends CardImpl {
    public ParagonOfTheAmesha(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{W}");
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.KNIGHT);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);
        this.addAbility((Ability)FirstStrikeAbility.getInstance());
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new ParagonOfTheAmeshaEffect(), (Cost)new ManaCostsImpl("{W}{U}{B}{R}{G}"));
        BoostSourceEffect effect = new BoostSourceEffect(3, 3, Duration.EndOfTurn);
        effect.setText(", gets +3/+3");
        ability.addEffect((Effect)effect);
        effect = new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn);
        effect.setText(", and gains flying");
        ability.addEffect((Effect)effect);
        effect = new GainAbilitySourceEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn);
        effect.setText("and lifelink");
        ability.addEffect((Effect)effect);
        this.addAbility((Ability)ability);
    }

    private ParagonOfTheAmesha(ParagonOfTheAmesha card) {
        super((CardImpl)card);
    }

    public ParagonOfTheAmesha copy() {
        return new ParagonOfTheAmesha(this);
    }

    private static class ParagonOfTheAmeshaEffect
    extends ContinuousEffectImpl {
        private ParagonOfTheAmeshaEffect() {
            super(Duration.EndOfTurn, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.BecomeCreature);
            this.staticText = "Until end of turn, {this} becomes an Angel";
        }

        private ParagonOfTheAmeshaEffect(ParagonOfTheAmeshaEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public ParagonOfTheAmeshaEffect copy() {
            return new ParagonOfTheAmeshaEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Permanent permanent = game.getPermanent(source.getSourceId());
            if (permanent == null) {
                return false;
            }
            permanent.removeAllCreatureTypes(game);
            permanent.addSubType(game, new SubType[]{SubType.ANGEL});
            return true;
        }
    }
}

