/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class ParanormalAnalystEffect
extends OneShotEffect {
    ParanormalAnalystEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a card you put into your graveyard this way into your hand";
    }

    private ParanormalAnalystEffect(ParanormalAnalystEffect effect) {
        super((OneShotEffect)effect);
    }

    public ParanormalAnalystEffect copy() {
        return new ParanormalAnalystEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        cards.retainZone(Zone.GRAVEYARD, game);
        switch (cards.size()) {
            case 0: {
                return false;
            }
            case 1: {
                card = cards.getRandom(game);
                break;
            }
            default: {
                TargetCardInYourGraveyard target = new TargetCardInYourGraveyard();
                target.withNotTarget(true);
                player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
                card = game.getCard(target.getFirstTarget());
            }
        }
        return player.moveCards(card, Zone.HAND, source, game);
    }
}

