/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ParaseleneEffect
extends OneShotEffect {
    ParaseleneEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all enchantments. You gain 1 life for each enchantment destroyed this way";
    }

    private ParaseleneEffect(ParaseleneEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        int count = 0;
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_ENCHANTMENT, source.getControllerId(), source, game)) {
            if (!permanent.destroy(source, game, false)) continue;
            ++count;
        }
        if (count > 0 && (player = game.getPlayer(source.getControllerId())) != null) {
            player.gainLife(count, game, source);
        }
        return true;
    }

    public ParaseleneEffect copy() {
        return new ParaseleneEffect(this);
    }
}

