/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ParoxysmEffect
extends OneShotEffect {
    ParoxysmEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "that player reveals the top card of their library. If that card is a land card, destroy that creature. Otherwise, it gets +3/+3 until end of turn.";
    }

    private ParoxysmEffect(ParoxysmEffect effect) {
        super((OneShotEffect)effect);
    }

    public ParoxysmEffect copy() {
        return new ParoxysmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card revealCardFromTop;
        Player controllerOfCreature;
        Permanent creatureAttachedTo;
        Permanent aura = game.getPermanent(source.getSourceId());
        if (aura != null && (creatureAttachedTo = game.getPermanent(aura.getAttachedTo())) != null && (controllerOfCreature = game.getPlayer(creatureAttachedTo.getControllerId())) != null && (revealCardFromTop = controllerOfCreature.getLibrary().getFromTop(game)) != null) {
            CardsImpl cards = new CardsImpl(revealCardFromTop);
            controllerOfCreature.revealCards(source, (Cards)cards, game);
            if (revealCardFromTop.isLand(game)) {
                creatureAttachedTo.destroy(source, game, false);
            } else {
                BoostTargetEffect effect = new BoostTargetEffect(3, 3, Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creatureAttachedTo.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

