/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlashbackAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class PastInFlamesEffect
extends ContinuousEffectImpl {
    PastInFlamesEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each instant and sorcery card in your graveyard gains flashback until end of turn. The flashback cost is equal to its mana cost";
    }

    private PastInFlamesEffect(PastInFlamesEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public PastInFlamesEffect copy() {
        return new PastInFlamesEffect(this);
    }

    public void init(Ability source, Game game) {
        Player player;
        super.init(source, game);
        if (this.getAffectedObjectsSet() && (player = game.getPlayer(source.getControllerId())) != null) {
            player.getGraveyard().stream().map(cardId -> game.getCard(cardId)).filter(card1 -> card1.isInstantOrSorcery(game)).forEachOrdered(card -> this.affectedObjectList.add(new MageObjectReference((MageObject)card, game)));
        }
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.getGraveyard().stream().filter(cardId -> this.affectedObjectList.contains(new MageObjectReference(cardId, game))).forEachOrdered(cardId -> {
            Card card = game.getCard(cardId);
            if (card != null) {
                FlashbackAbility ability = new FlashbackAbility(card, (Cost)card.getManaCost());
                ability.setSourceId(cardId);
                ability.setControllerId(card.getOwnerId());
                game.getState().addOtherAbility(card, (Ability)ability);
            }
        });
        return true;
    }
}

