/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.abilities.mana.CommanderColorIdentityManaAbility;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class PathOfAncestryTriggeredAbility
extends DelayedTriggeredAbility {
    PathOfAncestryTriggeredAbility() {
        super((Effect)new ScryEffect(1), Duration.Custom, true, false);
    }

    private PathOfAncestryTriggeredAbility(PathOfAncestryTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public PathOfAncestryTriggeredAbility copy() {
        return new PathOfAncestryTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MANA_PAID;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        block8: {
            block7: {
                if (!this.getSourceId().equals(event.getSourceId())) {
                    return false;
                }
                Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(this.getSourceId());
                if (sourcePermanent == null) break block7;
                if (!sourcePermanent.getAbilities(game).stream().filter(CommanderColorIdentityManaAbility.class::isInstance).map(Ability::getOriginalId).map(UUID::toString).noneMatch(event.getData()::equals)) break block8;
            }
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null) {
            return false;
        }
        Player player = game.getPlayer(this.getControllerId());
        if (player == null) {
            return false;
        }
        for (Card commander : game.getCommanderCardsFromAnyZones(player, CommanderCardType.COMMANDER_OR_OATHBREAKER, new Zone[]{Zone.ALL})) {
            if (!spell.getCard().shareCreatureTypes(game, (MageObject)commander)) continue;
            return true;
        }
        return false;
    }

    public boolean isInactive(Game game) {
        if (super.isInactive(game)) {
            return true;
        }
        Player player = game.getPlayer(this.getControllerId());
        if (player == null) {
            return true;
        }
        return player.getManaPool().getManaItems().stream().noneMatch(m -> m.getSourceId().equals(this.getSourceId()));
    }

    public String getRule() {
        return "When that mana is spent to cast a creature spell that shares a creature type with your commander, scry 1. <i>(Look at the top card of your library. You may put that card on the bottom of your library.)</i>";
    }
}

