/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.BearToken;
import mage.players.Player;
import mage.target.Target;

class PathToTheWorldTreeEffect
extends OneShotEffect {
    PathToTheWorldTreeEffect() {
        super(Outcome.Benefit);
        this.staticText = "You gain 2 life and draw two cards. Target opponent loses 2 life. {this} deals 2 damage to up to one target creature. You create a 2/2 green Bear creature token.";
    }

    private PathToTheWorldTreeEffect(PathToTheWorldTreeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PathToTheWorldTreeEffect copy() {
        return new PathToTheWorldTreeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.gainLife(2, game, source);
            controller.drawCards(2, source, game);
        }
        for (UUID targetId : source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).collect(Collectors.toList())) {
            Permanent permanent;
            Player player = game.getPlayer(targetId);
            if (player != null) {
                player.loseLife(2, game, source, false);
            }
            if ((permanent = game.getPermanent(targetId)) == null) continue;
            permanent.damage(2, source.getSourceId(), source, game);
        }
        new BearToken().putOntoBattlefield(1, game, source, source.getControllerId());
        return true;
    }
}

