/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.TargetPermanent;
import mage.target.targetadjustment.DefineByTriggerTargetAdjuster;
import mage.target.targetadjustment.TargetAdjuster;

class PawpatchRecruitTriggeredAbility
extends TriggeredAbilityImpl {
    public PawpatchRecruitTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), false);
        this.setTargetAdjuster((TargetAdjuster)DefineByTriggerTargetAdjuster.instance);
    }

    private PawpatchRecruitTriggeredAbility(PawpatchRecruitTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PawpatchRecruitTriggeredAbility copy() {
        return new PawpatchRecruitTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature you control becomes the target of a spell or ability an opponent controls, put a +1/+1 counter on target creature you control other than that creature.";
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGETED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null || !StaticFilters.FILTER_CONTROLLED_A_CREATURE.match(permanent, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        StackObject targetingObject = game.findTargetingStackObject(this.getId().toString(), event);
        if (targetingObject == null || !StaticFilters.FILTER_SPELL_OR_ABILITY_OPPONENTS.match(targetingObject, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        this.getTargets().clear();
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();
        filter.add(Predicates.not((Predicate)new MageObjectReferencePredicate(event.getTargetId(), game)));
        this.addTarget(new TargetPermanent((FilterPermanent)filter).withChooseHint("other than that creature, for +1/+1 counter"));
        return true;
    }
}

