/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class PeaceTalksPlayersAndPermanentsCantBeTargetsOfSpellsOrActivatedAbilities
extends ContinuousRuleModifyingEffectImpl {
    int startedTurnNum = 0;

    public PeaceTalksPlayersAndPermanentsCantBeTargetsOfSpellsOrActivatedAbilities() {
        super(Duration.Custom, Outcome.Neutral);
        this.staticText = "players and permanents can't be the targets of spells or activated abilities";
    }

    private PeaceTalksPlayersAndPermanentsCantBeTargetsOfSpellsOrActivatedAbilities(PeaceTalksPlayersAndPermanentsCantBeTargetsOfSpellsOrActivatedAbilities effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.startedTurnNum = effect.startedTurnNum;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.startedTurnNum = game.getTurnNum();
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGET;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            if (!event.getTargetId().equals(playerId)) continue;
            return true;
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
            if (!event.getTargetId().equals(permanent.getId())) continue;
            return true;
        }
        return false;
    }

    public PeaceTalksPlayersAndPermanentsCantBeTargetsOfSpellsOrActivatedAbilities copy() {
        return new PeaceTalksPlayersAndPermanentsCantBeTargetsOfSpellsOrActivatedAbilities(this);
    }

    public boolean isInactive(Ability source, Game game) {
        if (game.getTurnNum() > this.startedTurnNum + 1) {
            this.discard();
            return true;
        }
        return false;
    }
}

