/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class PedanticLearningTriggeredAbility
extends TriggeredAbilityImpl {
    public PedanticLearningTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new DrawCardSourceControllerEffect(1), (Cost)new ManaCostsImpl("{1}")), false);
    }

    private PedanticLearningTriggeredAbility(PedanticLearningTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID cardOwnerId;
        Card card;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent != null && zEvent.getFromZone() == Zone.LIBRARY && zEvent.getToZone() == Zone.GRAVEYARD && (card = game.getCard(event.getTargetId())) != null && (cardOwnerId = card.getOwnerId()) != null && card.isOwnedBy(this.getControllerId()) && card.isLand(game);
    }

    public PedanticLearningTriggeredAbility copy() {
        return new PedanticLearningTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a land card is put into your graveyard from your library, you may pay {1}. If you do, draw a card.";
    }
}

