/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PemminsAuraBoostEnchantedEffect
extends OneShotEffect {
    private static String CHOICE_1 = "+1/-1";
    private static String CHOICE_2 = "-1/+1";

    public PemminsAuraBoostEnchantedEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Enchanted creature gets +1/-1 or -1/+1 until end of turn";
    }

    private PemminsAuraBoostEnchantedEffect(PemminsAuraBoostEnchantedEffect effect) {
        super((OneShotEffect)effect);
    }

    public PemminsAuraBoostEnchantedEffect copy() {
        return new PemminsAuraBoostEnchantedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (controller == null || enchantment == null) {
            return false;
        }
        Permanent creature = game.getPermanent(enchantment.getAttachedTo());
        if (creature == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Select how to boost");
        choice.getChoices().add(CHOICE_1);
        choice.getChoices().add(CHOICE_2);
        if (controller.choose(this.outcome, (Choice)choice, game)) {
            if (choice.getChoice().equals(CHOICE_1)) {
                game.addEffect((ContinuousEffect)new BoostEnchantedEffect(1, -1, Duration.EndOfTurn), source);
            } else {
                game.addEffect((ContinuousEffect)new BoostEnchantedEffect(-1, 1, Duration.EndOfTurn), source);
            }
            return true;
        }
        return false;
    }
}

