/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.FoodToken;

class PeregrinTookReplacementEffect
extends ReplacementEffectImpl {
    PeregrinTookReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If one or more tokens would be created under your control, those tokens plus an additional Food token are created instead";
    }

    private PeregrinTookReplacementEffect(PeregrinTookReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PeregrinTookReplacementEffect copy() {
        return new PeregrinTookReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (event instanceof CreateTokenEvent) {
            CreateTokenEvent tokenEvent = (CreateTokenEvent)event;
            FoodToken foodToken = null;
            Map tokens = tokenEvent.getTokens();
            for (Map.Entry entry : tokens.entrySet()) {
                if (!(entry.getKey() instanceof FoodToken)) continue;
                foodToken = (FoodToken)entry.getKey();
            }
            if (foodToken == null) {
                foodToken = new FoodToken();
            }
            tokens.put(foodToken, tokens.getOrDefault(foodToken, 0) + 1);
        }
        return false;
    }
}

