/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PerilousVoyageEffect
extends OneShotEffect {
    PerilousVoyageEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target nonland permanent you don't control to its owner's hand. If its mana value was 2 or less, scry 2";
    }

    private PerilousVoyageEffect(PerilousVoyageEffect effect) {
        super((OneShotEffect)effect);
    }

    public PerilousVoyageEffect copy() {
        return new PerilousVoyageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        boolean flag = permanent.getManaValue() <= 2;
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        if (flag) {
            player.scry(2, source, game);
        }
        return true;
    }
}

