/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.util.CardUtil;

class PerniciousDeedEffect
extends OneShotEffect {
    PerniciousDeedEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy each artifact, creature, and enchantment with mana value X or less";
    }

    private PerniciousDeedEffect(PerniciousDeedEffect effect) {
        super((OneShotEffect)effect);
    }

    public PerniciousDeedEffect copy() {
        return new PerniciousDeedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterPermanent filter = new FilterPermanent("artifacts, creatures, and enchantments");
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate()}));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0) + 1));
        return new DestroyAllEffect(filter).apply(game, source);
    }
}

