/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class PersecuteEffect
extends OneShotEffect {
    PersecuteEffect() {
        super(Outcome.Discard);
        this.staticText = "Choose a color. Target player reveals their hand and discards all cards of that color";
    }

    private PersecuteEffect(PersecuteEffect effect) {
        super((OneShotEffect)effect);
    }

    public PersecuteEffect copy() {
        return new PersecuteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        ChoiceColor choice = new ChoiceColor();
        if (controller == null || sourceObject == null || targetPlayer == null || !controller.choose(this.outcome, (Choice)choice, game)) {
            return false;
        }
        FilterCard filterCard = new FilterCard();
        filterCard.add((Predicate)new ColorPredicate(choice.getColor()));
        targetPlayer.revealCards(source, targetPlayer.getHand(), game);
        targetPlayer.discard((Cards)new CardsImpl(targetPlayer.getHand().getCards(filterCard, game)), false, source, game);
        return true;
    }
}

