/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.TargetPlayer;

class PersonalIncarnationRedirectEffect
extends RedirectionEffect {
    PersonalIncarnationRedirectEffect() {
        super(Duration.EndOfTurn, 1, RedirectionEffect.UsageType.ONE_USAGE_ABSOLUTE);
        this.staticText = "The next 1 damage that would be dealt to {this} this turn is dealt to its owner instead.";
    }

    private PersonalIncarnationRedirectEffect(PersonalIncarnationRedirectEffect effect) {
        super((RedirectionEffect)effect);
    }

    public PersonalIncarnationRedirectEffect copy() {
        return new PersonalIncarnationRedirectEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getSourceId())) {
            TargetPlayer target = new TargetPlayer();
            target.add(game.getOwnerId(source.getSourceId()), game);
            this.redirectTarget = target;
            return true;
        }
        return false;
    }
}

