/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ParleyCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.CitizenGreenWhiteToken;
import mage.players.Player;

class PhabineBosssConfidantParleyEffect
extends OneShotEffect {
    PhabineBosssConfidantParleyEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player reveals the top card of their library. For each land card revealed this way, you create a 1/1 green and white Citizen creature token. Then creatures you control get +1/+1 until end of turn for each nonland card revealed this way.";
    }

    private PhabineBosssConfidantParleyEffect(PhabineBosssConfidantParleyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int nonLandCount = ParleyCount.getInstance().calculate(game, source, (Effect)this);
        int nonEmptyLibraries = 0;
        for (UUID playerID : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerID);
            if (player == null || player.getLibrary().size() == 0) continue;
            ++nonEmptyLibraries;
        }
        int landCount = nonEmptyLibraries - nonLandCount;
        if (landCount > 0) {
            CitizenGreenWhiteToken citizenToken = new CitizenGreenWhiteToken();
            citizenToken.putOntoBattlefield(landCount, game, source, source.getControllerId(), false, false);
            game.processAction();
        }
        if (nonLandCount > 0) {
            BoostControlledEffect boostEffect = new BoostControlledEffect(nonLandCount, nonLandCount, Duration.EndOfTurn);
            game.addEffect((ContinuousEffect)boostEffect, source);
        }
        return true;
    }

    public PhabineBosssConfidantParleyEffect copy() {
        return new PhabineBosssConfidantParleyEffect(this);
    }
}

