/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class PhantasmalMountDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    UUID creatureId;

    PhantasmalMountDelayedTriggeredAbility(Effect effect, UUID creatureId) {
        super(effect, Duration.EndOfTurn, true);
        this.creatureId = creatureId;
    }

    private PhantasmalMountDelayedTriggeredAbility(PhantasmalMountDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.creatureId = ability.creatureId;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE && event.getTargetId().equals(this.creatureId);
    }

    public PhantasmalMountDelayedTriggeredAbility copy() {
        return new PhantasmalMountDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "this left the battlefield";
    }
}

