/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.StateTriggeredAbility;
import mage.abilities.common.AsEntersBattlefieldAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.p.PhylacteryLichEffect;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public final class PhylacteryLich
extends CardImpl {
    public PhylacteryLich(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{B}{B}{B}");
        this.subtype.add((Object)SubType.ZOMBIE);
        this.power = new MageInt(5);
        this.toughness = new MageInt(5);
        this.addAbility((Ability)IndestructibleAbility.getInstance());
        this.addAbility((Ability)new AsEntersBattlefieldAbility((Effect)new PhylacteryLichEffect(), "put a phylactery counter on an artifact you control"));
        this.addAbility((Ability)new PhylacteryLichAbility());
    }

    private PhylacteryLich(PhylacteryLich card) {
        super((CardImpl)card);
    }

    public PhylacteryLich copy() {
        return new PhylacteryLich(this);
    }

    static class PhylacteryLichAbility
    extends StateTriggeredAbility {
        public PhylacteryLichAbility() {
            super(Zone.BATTLEFIELD, (Effect)new SacrificeSourceEffect());
        }

        private PhylacteryLichAbility(PhylacteryLichAbility ability) {
            super((StateTriggeredAbility)ability);
        }

        public PhylacteryLichAbility copy() {
            return new PhylacteryLichAbility(this);
        }

        public boolean checkTrigger(GameEvent event, Game game) {
            for (Permanent perm : game.getBattlefield().getAllActivePermanents(this.controllerId)) {
                if (perm.getCounters(game).getCount(CounterType.PHYLACTERY) <= 0) continue;
                return false;
            }
            return true;
        }

        public String getRule() {
            return "When you control no permanents with phylactery counters on them, sacrifice {this}.";
        }
    }
}

