/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.PhyrexianMinionToken;
import mage.game.permanent.token.Token;
import mage.util.CardUtil;

class PhyrexianProcessorCreateTokenEffect
extends OneShotEffect {
    PhyrexianProcessorCreateTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create an X/X black Phyrexian Minion creature token, where X is the life paid as {this} entered the battlefield.";
    }

    private PhyrexianProcessorCreateTokenEffect(PhyrexianProcessorCreateTokenEffect ability) {
        super((OneShotEffect)ability);
    }

    public PhyrexianProcessorCreateTokenEffect copy() {
        return new PhyrexianProcessorCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String key = CardUtil.getCardZoneString((String)"lifePaid", (UUID)source.getSourceId(), (Game)game, (boolean)true);
        Object object = game.getState().getValue(key);
        if (object instanceof Integer) {
            int xvalue = (Integer)object;
            return new CreateTokenEffect((Token)new PhyrexianMinionToken(xvalue)).apply(game, source);
        }
        return false;
    }
}

