/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Objects;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.LoseAbilityTargetEffect;
import mage.cards.p.PhyrexianSplicerChooseCost;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class PhyrexianSplicerEffect
extends OneShotEffect {
    PhyrexianSplicerEffect() {
        super(Outcome.LoseAbility);
        this.staticText = "Until end of turn, target creature with the chosen ability loses it and another target creature gains it.";
    }

    private PhyrexianSplicerEffect(PhyrexianSplicerEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhyrexianSplicerEffect copy() {
        return new PhyrexianSplicerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        LoseAbilityTargetEffect effect;
        Ability loseAbility = PhyrexianSplicerEffect.findChosenAbility(source);
        if (loseAbility == null) {
            return false;
        }
        Permanent targetLose = game.getPermanent(((Target)source.getTargets().get(0)).getFirstTarget());
        Permanent targetGain = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (targetGain == null) {
            return false;
        }
        if (targetLose != null) {
            effect = new LoseAbilityTargetEffect(loseAbility, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetLose, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        effect = new GainAbilityTargetEffect(loseAbility, Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(targetGain, game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }

    static Ability findChosenAbility(Ability source) {
        return CardUtil.castStream((Stream)source.getCosts().stream(), PhyrexianSplicerChooseCost.class).map(PhyrexianSplicerChooseCost::getTargetedAbility).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

