/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterAnyTarget;
import mage.filter.common.FilterPermanentOrPlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetPermanentOrPlayer;

class PhyrexianVindicatorEffect
extends ReplacementEffectImpl {
    private static final FilterAnyTarget filter = new FilterAnyTarget("any other target");

    public PhyrexianVindicatorEffect() {
        super(Duration.WhileOnBattlefield, Outcome.PreventDamage);
        this.staticText = "If damage would be dealt to {this}, prevent that damage. When damage is prevented this way, {this} deals that much damage to any other target.";
    }

    private PhyrexianVindicatorEffect(PhyrexianVindicatorEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PhyrexianVindicatorEffect copy() {
        return new PhyrexianVindicatorEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int damage = game.preventDamage(event, source, game, Integer.MAX_VALUE).getPreventedDamage();
        if (damage > 0) {
            ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(damage), false, "{this} deals that much damage to any other target");
            ability.addTarget((Target)new TargetPermanentOrPlayer((FilterPermanentOrPlayer)filter));
            game.fireReflexiveTriggeredAbility(ability, source);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId());
    }

    static {
        filter.getPermanentFilter().add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

