/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.condition.common.DeliriumCondition;
import mage.abilities.effects.common.search.SearchTargetGraveyardHandLibraryForCardNameAndExileEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class PickTheBrainEffect
extends SearchTargetGraveyardHandLibraryForCardNameAndExileEffect {
    PickTheBrainEffect() {
        super(true, "that card's controller", "all cards with the same name as that card");
        this.staticText = "Target opponent reveals their hand. You choose a nonland card from it and exile that card.<br><br><i>Delirium</i> &mdash; If there are four or more card types among cards in your graveyard, search that player's graveyard, hand, and library for any number of cards with the same name as the exiled card, exile those cards, then that player shuffles";
    }

    private PickTheBrainEffect(PickTheBrainEffect effect) {
        super((SearchTargetGraveyardHandLibraryForCardNameAndExileEffect)effect);
    }

    public PickTheBrainEffect copy() {
        return new PickTheBrainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (opponent != null && controller != null && !opponent.getHand().isEmpty()) {
            Card card;
            opponent.revealCards("Exile " + StaticFilters.FILTER_CARD_A_NON_LAND.getMessage(), opponent.getHand(), game);
            TargetCard target = new TargetCard(Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
            if (controller.choose(Outcome.Exile, opponent.getHand(), target, source, game) && (card = opponent.getHand().get(target.getFirstTarget(), game)) != null) {
                controller.moveCardToExileWithInfo(card, null, "", source, game, Zone.HAND, true);
                if (!DeliriumCondition.instance.apply(game, source)) {
                    return true;
                }
                return this.applySearchAndExile(game, source, card.getName(), opponent.getId());
            }
        }
        return false;
    }
}

