/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Exile;
import mage.game.Game;
import mage.game.permanent.token.RobotToken;
import mage.players.Player;
import mage.util.CardUtil;

class PinnacleStarcageTokenEffect
extends OneShotEffect {
    PinnacleStarcageTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "put each card exiled with this artifact into its owner's graveyard, then create a 2/2 colorless Robot artifact creature token for each card put into a graveyard this way";
    }

    private PinnacleStarcageTokenEffect(PinnacleStarcageTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public PinnacleStarcageTokenEffect copy() {
        return new PinnacleStarcageTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Optional.ofNullable(CardUtil.getExileZoneId((Game)game, (Ability)source)).map(arg_0 -> ((Exile)game.getExile()).getExileZone(arg_0)).map(e -> e.getCards(game)).ifPresent(arg_0 -> ((Cards)cards).addAllCards(arg_0));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        cards.retainZone(Zone.GRAVEYARD, game);
        if (cards.size() > 0) {
            new RobotToken().putOntoBattlefield(cards.size(), game, source);
        }
        return true;
    }
}

