/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.cards.CardsImpl;
import mage.choices.ChooseFriendsAndFoes;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PirsWhimEffect
extends OneShotEffect {
    PirsWhimEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each player, choose friend or foe. Each friend searches their library for a land card, puts it onto the battlefield tapped, then shuffles. Each foe sacrifices an artifact or enchantment they control.";
    }

    private PirsWhimEffect(PirsWhimEffect effect) {
        super((OneShotEffect)effect);
    }

    public PirsWhimEffect copy() {
        return new PirsWhimEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ChooseFriendsAndFoes choice = new ChooseFriendsAndFoes();
        if (controller != null && !choice.chooseFriendOrFoe(controller, source, game)) {
            return false;
        }
        for (Player player : choice.getFriends()) {
            TargetCardInLibrary target;
            if (player == null || !player.searchLibrary(target = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND), source, game)) continue;
            player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, true, null);
            player.shuffleLibrary(source, game);
        }
        for (Player player : choice.getFoes()) {
            if (player == null) continue;
            SacrificeEffect effect = new SacrificeEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT_OR_ENCHANTMENT, 1, "");
            effect.setTargetPointer((TargetPointer)new FixedTarget(player.getId(), game));
            effect.apply(game, source);
        }
        return true;
    }
}

