/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.abilities.keyword.ExhaustAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PitAutomatonTriggeredAbility
extends DelayedTriggeredAbility {
    PitAutomatonTriggeredAbility() {
        super((Effect)new CopyTargetStackObjectEffect(true), Duration.EndOfTurn, true, false);
    }

    private PitAutomatonTriggeredAbility(PitAutomatonTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public PitAutomatonTriggeredAbility copy() {
        return new PitAutomatonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        StackObject stackObject = game.getStack().getStackObject(event.getTargetId());
        if (stackObject == null || !(stackObject.getStackAbility() instanceof ExhaustAbility)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
        return true;
    }

    public String getRule() {
        return "When you next activate an exhaust ability that isn't a mana ability this turn, copy it. You may choose new targets for the copy.";
    }
}

