/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PlagueBoilerEffect
extends OneShotEffect {
    PlagueBoilerEffect() {
        super(Outcome.Detriment);
        this.staticText = "Put a plague counter on {this} or remove a plague counter from it";
    }

    private PlagueBoilerEffect(PlagueBoilerEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlagueBoilerEffect copy() {
        return new PlagueBoilerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            if (!sourcePermanent.getCounters(game).containsKey(CounterType.PLAGUE) || controller.chooseUse(this.outcome, "Put a plague counter on? (No removes one)", source, game)) {
                return new AddCountersSourceEffect(CounterType.PLAGUE.createInstance(), true).apply(game, source);
            }
            return new RemoveCounterSourceEffect(CounterType.PLAGUE.createInstance()).apply(game, source);
        }
        return false;
    }
}

