/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PlagueReaverSacrificeEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    PlagueReaverSacrificeEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice each other creature you control";
    }

    private PlagueReaverSacrificeEffect(PlagueReaverSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlagueReaverSacrificeEffect copy() {
        return new PlagueReaverSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

