/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.BlockingAttackerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PlagueWightEffect
extends OneShotEffect {
    PlagueWightEffect() {
        super(Outcome.Benefit);
        this.staticText = "each creature blocking it gets -1/-1 until end of turn.";
    }

    private PlagueWightEffect(PlagueWightEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlagueWightEffect copy() {
        return new PlagueWightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new BlockingAttackerIdPredicate(source.getSourceId()));
        game.addEffect((ContinuousEffect)new BoostAllEffect(-1, -1, Duration.EndOfTurn, filter, false), source);
        return true;
    }
}

