/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PlaguecrafterEffect
extends OneShotEffect {
    PlaguecrafterEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player sacrifices a creature or planeswalker of their choice. Each player who can't discards a card.";
    }

    private PlaguecrafterEffect(PlaguecrafterEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlaguecrafterEffect copy() {
        return new PlaguecrafterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList perms = new ArrayList();
        ArrayList<UUID> cantSac = new ArrayList<UUID>();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            TargetSacrifice target = new TargetSacrifice(StaticFilters.FILTER_CONTROLLED_PERMANENT_CREATURE_OR_PLANESWALKER);
            if (target.canChoose(player.getId(), source, game)) {
                while (!target.isChosen(game) && player.canRespond()) {
                    player.choose(Outcome.Sacrifice, (Target)target, source, game);
                }
                perms.addAll(target.getTargets());
                continue;
            }
            cantSac.add(playerId);
        }
        for (UUID permID : perms) {
            Permanent permanent = game.getPermanent(permID);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        for (UUID playerId : cantSac) {
            DiscardTargetEffect discardEffect = new DiscardTargetEffect(1);
            discardEffect.setTargetPointer((TargetPointer)new FixedTarget(playerId, game));
            discardEffect.apply(game, source);
        }
        return true;
    }
}

