/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class PlanarChaosCastAllEffect
extends OneShotEffect {
    PlanarChaosCastAllEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player flips a coin. If they lose the flip, counter that spell";
    }

    private PlanarChaosCastAllEffect(PlanarChaosCastAllEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlanarChaosCastAllEffect copy() {
        return new PlanarChaosCastAllEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject;
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            spell = (Spell)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.STACK);
        }
        if ((sourceObject = source.getSourceObject(game)) != null && spell != null) {
            Player caster = game.getPlayer(spell.getControllerId());
            if (caster != null && !caster.flipCoin(source, game, true)) {
                game.informPlayers(sourceObject.getLogName() + ": " + spell.getLogName() + " countered");
                game.getStack().counter(this.getTargetPointer().getFirst(game, source), source, game);
            }
            return true;
        }
        return false;
    }
}

