/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PlanarChaosUpkeepEffect
extends OneShotEffect {
    PlanarChaosUpkeepEffect() {
        super(Outcome.Damage);
        this.staticText = "flip a coin. If you lose the flip, sacrifice {this}";
    }

    private PlanarChaosUpkeepEffect(PlanarChaosUpkeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && !player.flipCoin(source, game, true)) {
            Permanent perm = game.getPermanent(source.getSourceId());
            if (perm != null) {
                perm.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }

    public PlanarChaosUpkeepEffect copy() {
        return new PlanarChaosUpkeepEffect(this);
    }
}

