/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class PlanarIncisionEffect
extends OneShotEffect {
    PlanarIncisionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target artifact or creature, then return it to the battlefield under its owner's control with a +1/+1 counter on it";
    }

    private PlanarIncisionEffect(PlanarIncisionEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlanarIncisionEffect copy() {
        return new PlanarIncisionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card exiledCard;
        UUID exileId;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent != null && controller != null && controller.moveCardsToExile((Card)permanent, source, game, true, exileId = CardUtil.getExileZoneId((String)("planarIncisionExile" + source.toString()), (Game)game), "") && game.getExile().getExileZone(exileId) != null && (exiledCard = game.getExile().getExileZone(exileId).get(permanent.getId(), game)) != null) {
            Counters countersToAdd = new Counters(new Counter[0]);
            countersToAdd.addCounter(CounterType.P1P1.createInstance());
            game.setEnterWithCounters(exiledCard.getId(), countersToAdd);
            return controller.moveCards(exiledCard, Zone.BATTLEFIELD, source, game, false, false, true, null);
        }
        return false;
    }
}

